import unittest
from ..compat_tempfile import TemporaryDirectory


class TestTemporaryFile(unittest.TestCase):

    def test_temporaryfile(self):
        with TemporaryDirectory() as tmpdir:
            open(tmpdir + '/test', 'w').write('Test')
            other_ref = tmpdir
            ret = open(other_ref + '/test', 'r').read()
            self.assertEqual(ret, 'Test')

        with self.assertRaises(IOError):
            open(other_ref + '/test', 'r').read()
